"use client"

import { motion} from "framer-motion";
import {useEffect, useState} from "react";

export default function IntroContainer({plans = [], setPlanKind}) {


    const planItems = Object.entries(plans).map(([id, name]) => ({
        id,
        name,
    }));


    const [selectedPlanItem, setSelectedPlanItem] = useState({});

    useEffect(() => {
        if (planItems.length > 0) {
            setSelectedPlanItem(planItems[0]);
            setPlanKind(planItems[0].name);
        }
    }, [plans]);



    return (
        <>
            <div className="w-full relative flex flex-col items-center justify-center bg-white gap-16 mx-auto pt-20 pb-28 md:px-8 md:pb-4">

                <div className="absolute -right-2 top-10 h-60 w-36 blur-2xl bg-primary-main/20 rounded-bl-full rounded-tl-full md:hidden"></div>
                <div className="absolute left-0 top-32 h-60 w-24 blur-2xl bg-primary-main/15 rounded-br-full rounded-tr-full md:hidden"></div>

                <div className="flex flex-col gap-3 justify-center items-center">

                    <h1 className="text-right md:text-right md:text-t3 text-[30px] leading-[60px] text-secondary-main font-extrabold">
                        دسترسی نامحدود با
                        <span className="text-primary-main"> اشتراک راوی حساب</span>
                    </h1>

                    <p className="text-muted text-[15px] text-center leading-[45px] md:justify-center md:text-md md:leading-[45px]">
                        با داشتن اشتراک میتوانید از تمامی امکانات راوی حساب استفاده کنید؛ تنها کافیست اشتراک راوی حساب را تهیه کرده و به سطح جدیدی در مالیات برسید!
                    </p>
                </div>



                <div className="flex flex-col gap-3 justify-center items-center">
                    <div className="text-t3 font-extrabold leading-[50px]">
                        <span className="text-primary-main">۱۰۰+ </span>
                        اشتراک فعال در راوی حساب
                    </div>


                    <div className="flex p-1.5 w-fit justify-center items-center bg-secondary-main rounded-xl">
                        {planItems.map((item) => (
                            <button
                                key={item.id}
                                onClick={() => {
                                    setSelectedPlanItem(item);
                                    setPlanKind(item.name)
                                }}
                                className={`relative py-1.5 px-8 rounded-lg text-[15px] font-bold md:py-2.5 md:text-[16px] flex`}
                            >
                                {selectedPlanItem?.id === item.id && (
                                    <motion.span
                                        layoutId="intro-bg"
                                        transition={{
                                            type: "spring",
                                            stiffness: 300,
                                            damping: 25
                                        }}
                                        className="absolute inset-0 bg-primary-main rounded-lg"
                                        initial={false}
                                        animate={{
                                            scale: [1, 1.05, 1],
                                        }}
                                    />
                                )}
                                <motion.span
                                    className={`relative z-10`}
                                    animate={{
                                        color: selectedPlanItem?.id === item.id ? "#0C0D0F" : "#fff",
                                    }}
                                    transition={{
                                        duration: 0.2,
                                        ease: "easeInOut"
                                    }}
                                >
                                    {item.name}
                                </motion.span>
                            </button>
                        ))}

                    </div>
                </div>


            </div>
        </>
    )
};