"use client";

import { useState } from "react";
import { motion } from "framer-motion";
import { IoIosArrowDown, IoIosArrowUp } from "react-icons/io";

export default function CalculatBenefitContainer() {
    const [expanded, setExpanded] = useState(false);

    return (
        <div className="flex flex-col gap-3 px-40 py-16 md:px-4 md:text-justify relative">
            <p className="font-[900] text-t3 text-secondary-main md:text-t2 md:w-full md:text-start">
                مزایای محاسبه آنلاین حقوق و دستمزد
            </p>

            <div className="relative">

                <motion.div
                    initial={false}
                    animate={{ height: expanded ? "auto" : "250px" }}
                    transition={{ duration: 0.6, ease: "easeInOut" }}
                    className="overflow-hidden relative max-h-fit"
                >
                    <p className="px-6 text-justify font-regular leading-8 text-secondary-main">
                        استانداردهای حسابداری شماره ۱ و ۲، دو استاندارد مهم حسابداری هستند که آشنایی با آنها، برای حسابداران
                        و مدیران مالی ضروری است. این دوره آموزشی، به شما کمک می‌کند تا با این دو استاندارد به طور کامل آشنا
                        شوید و مهارت‌های لازم برای تهیه و ارائه صورت‌های مالی و صورت جریان‌های نقدی را کسب کنید. در صورت تمایل به
                        تسلط به امور مالیاتی و آموزش مالیات جامع شما می توانید از طریق همین سایت به قسمت مربوطه مراجعه کنید.
                        همچنین در صورت تمایل به آموزش قوانین مالیاتی جدید به قسمت مربوطه مراجعه کنید تا همیشه به روز باشید
                        لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است چاپگرها
                        و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است و برای شرایط فعلی تکنولوژی مورد نیاز و
                        کاربردهای متنوع با هدف بهبود ابزارهای کاربردی می باشد کتابهای زیادی در شصت و سه درصد گذشته حال و
                        آینده شناخت فراوان جامعه و متخصصان را می طلبد
                    </p>
                </motion.div>


                <div className="absolute -bottom-10 left-0 w-full flex justify-center">
                    <button
                        onClick={() => setExpanded(!expanded)}
                        className="w-full flex justify-center items-center gap-1 text-primary-main font-bold text-body bg-white/80 px-4 pt-6 rounded-t-md"
                    >
                        {expanded ? (
                            <>
                                <span>مشاهده کمتر</span>
                                <IoIosArrowUp />
                            </>
                        ) : (
                            <div className="pt-3 flex items-center gap-1">
                                <span>مشاهده بیشتر</span>
                                <IoIosArrowDown />
                            </div>
                        )}
                    </button>
                </div>
            </div>
        </div>
    );
}
