import Image from "next/image";
import logo from "@/../public/icons/logo.svg"
import line from "@/../public/icons/line.svg"
import {IoMdAdd} from "react-icons/io";


export default function QuestionBar() {


    return (

        <div className="flex flex-col items-center justify-center gap-6">

            <div className="flex flex-col items-center gap-3">
                <p className="text-t2 font-black text-secondary-main md:text-center md:text-lg">سوالاتی که ممکن است برای شما پیش بیاید
                </p>
                <Image src={line} alt={"line"}/>
            </div>

            <p className="text-body w-[35%] text-muted leading-10 text-center md:w-full md:px-6">
                کاربران سوالات زیادی درباره اشتراک‌های ما پرسیده‌اند که در ادامه پر تکرارترین آنها را مشاهده میکنید؛ اگر
                سوال شما در این لیست نیست حتما با ما تماس بگیرید.
            </p>

            <div className="grid grid-cols-3 md:grid-cols-1 md:gap-8">

                <div className="col-span-2 flex flex-col h-full justify-between gap-3 md:col-span-1 md:mx-auto md:items-center px-4">

                        <div className="w-[95%] p-3 flex justify-between border border-border rounded-[10px]">

                            <p className="text-body font-semibold">
                                آیا کلاس های راوی حساب فقط آنلاین هستند؟
                            </p>

                            <IoMdAdd className="size-6"/>
                        </div>

                        <div className="w-[95%] p-3 flex justify-between border border-border rounded-[10px]">

                            <p className="text-body font-semibold">
                                لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده؟
                            </p>

                            <IoMdAdd className="size-6"/>
                        </div>


                        <div className="w-[95%] p-3 flex justify-between border border-border rounded-[10px]">

                            <p className="text-body font-semibold">
                                آیا کلاس های راوی حساب فقط آنلاین هستند؟
                            </p>

                            <IoMdAdd className="size-6"/>
                        </div>

                        <div className="w-[95%] p-3 flex justify-between border border-border rounded-[10px]">

                            <p className="text-body font-semibold">
                                آیا کلاس های راوی حساب فقط آنلاین هستند؟
                            </p>

                            <IoMdAdd className="size-6"/>
                        </div>

                        <div className="w-[95%] p-3 flex justify-between border border-border rounded-[10px]">

                            <p className="text-body font-semibold">
                                لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده؟
                            </p>

                            <IoMdAdd className="size-6"/>
                        </div>

                        <div className="w-[95%] p-3 flex justify-between border border-border rounded-[10px]">

                            <p className="text-body font-semibold">
                                آیا کلاس های راوی حساب فقط آنلاین هستند؟
                            </p>

                            <IoMdAdd className="size-6"/>
                        </div>

                </div>

                <div className="col-span-1 flex items-center justify-center w-[80%] md:col-span-1 md:w-[95%] md:mx-auto">

                    <div className="flex flex-col py-20 rounded-2xl bg-black items-center justify-center gap-6 w-fit">

                        <Image src={logo} alt={"logo"}/>

                        <p className="text-t2 font-black text-white text-center lg:text-t3">سوال شما وجود نداشت؟</p>


                        <p className="text-body w-[90%] text-center leading-10 text-white lg:text-sm">
                            از ما بپرسید، کارشناسان ما در راوی حساب همیشه آماده راهنمایی ما هستند.
                        </p>

                        <button className="bg-white rounded-lg font-bold text-body px-8 py-4">
                            سوالتو مطرح کن
                        </button>


                    </div>


                </div>


            </div>


        </div>
    )
}