import React, {useEffect} from "react";
import addIcon from "../../../../public/icons/addCircle.svg";
import removeIcon from "../../../../public/icons/removeCircle.svg";
import Image from "next/image";
import {FaAngleDown} from "react-icons/fa";
import {motion, AnimatePresence} from "framer-motion";


export default function AdvancedOptions({name, items, columns = 2, perColumn = 6, setSelectedOptions,}) {

    const chunked = Array.from({length: columns}, (_, colIndex) =>
        items.slice(colIndex * perColumn, (colIndex + 1) * perColumn)
    );

    const [showOptions, setShowOptions] = React.useState(false);

    console.toLocaleString(items)
    const [optionAdded, setOptionAdded] = React.useState();
    useEffect(()=>{
        setOptionAdded( Array(items?.length).fill(false))
    },[items])

    const toggleOption = (globalIndex) => {
        setOptionAdded((prev) => {
            return(
                prev.map((val, index) => index === globalIndex ? !val : val)
            )
            }
        );
    };


    useEffect(() => {
        if (setSelectedOptions) {
            const selectedItems = items.filter((_, index) => optionAdded[index]);
            setSelectedOptions(selectedItems);
        }
    }, [optionAdded]);

    const [hoveredIndex, setHoveredIndex] = React.useState(null);

    return (
        <div className="border-2 border-primary-main rounded-2xl">
            <button
                onClick={() => setShowOptions(!showOptions)}
                className="flex items-center w-full justify-between p-4"
            >
                <div className="flex items-center gap-2">
                    <div className="w-1.5 h-1.5 bg-primary-main"></div>
                    <div className="text-secondary-main text-lg font-bold">
                        {name}
                    </div>
                </div>


                <div>
                    <FaAngleDown
                        className={`text-secondary-main transition-transform duration-300 ${
                            showOptions ? "rotate-0" : "rotate-180"
                        }`}
                    />
                </div>
            </button>

            <AnimatePresence initial={false}>
                {showOptions && (
                    <motion.div
                        key="options"
                        initial={{height: 0, opacity: 0}}
                        animate={{height: "auto", opacity: 1}}
                        exit={{height: 0, opacity: 0}}
                        transition={{duration: 0.4, ease: "easeInOut"}}
                        className="overflow-hidden"
                    >
                        <hr className="h-0.5 bg-muted w-[98%] mx-auto"/>

                        <div className={`grid grid-cols-${columns} gap-4 p-4 md:grid-cols-1`}>
                            {chunked.map((columnItems, colIndex) => (
                                <div key={colIndex} className="flex flex-col gap-2">
                                    {columnItems.map((item, index) => {
                                        const globalIndex = colIndex * perColumn + index;
                                        return (
                                            <button
                                                onMouseEnter={() => setHoveredIndex(globalIndex)}
                                                onMouseLeave={() => setHoveredIndex(null)}
                                                key={globalIndex}
                                                onClick={() => toggleOption(globalIndex)}
                                                className="p-2 flex items-center justify-between gap-2"
                                            >
                                                <div className="relative">
                                                    {item?.name}
                                                    {hoveredIndex === globalIndex && (
                                                        <motion.div
                                                            initial={{opacity: 0, x: 10}}
                                                            animate={{opacity: 1, x: 0}}
                                                            exit={{opacity: 0, x: 10}}
                                                            transition={{duration: 0.2}}
                                                            className="sm:hidden absolute -top-5 right-full mr-2 -translate-y-1/2 ml-2 w-40 bg-primary-lighten/70 backdrop-blur-[2px] border-[0.5px] border-primary-main rounded-lg rounded-br-none py-2 px-3 text-[10px] text-secondary-main z-50 sm:right-2 sm:top-0"
                                                        >
                                                            {item?.description || "توضیحی وجود ندارد"}
                                                        </motion.div>
                                                    )}
                                                </div>

                                                <Image
                                                    src={addIcon}
                                                    alt=""
                                                    width={15}
                                                    height={15}
                                                    className={`${
                                                        optionAdded[globalIndex] ? "hidden" : "block"
                                                    }`}
                                                />
                                                <Image
                                                    src={removeIcon}
                                                    alt=""
                                                    width={15}
                                                    height={15}
                                                    className={`${
                                                        optionAdded[globalIndex] ? "block" : "hidden"
                                                    }`}
                                                />


                                            </button>
                                        );
                                    })}
                                </div>
                            ))}
                        </div>
                    </motion.div>
                )}
            </AnimatePresence>
        </div>
    );
}
