"use client";

import { useState } from "react";
import { motion } from "framer-motion";
import { IoIosArrowDown, IoIosArrowUp } from "react-icons/io";

export default function CalculatBenefitContainer({pageName, benefits}) {
    const [expanded, setExpanded] = useState(false);

    return (
        <div className="flex flex-col gap-3 px-32 py-16 md:px-4 md:text-justify relative">
            <p className="font-[900] text-t3 text-secondary-main md:text-t2 md:w-full md:text-start">
                مزایای {pageName}
            </p>

            <div className="relative">
                {/* متن با انیمیشن */}
                <motion.div
                    initial={false}
                    animate={{ height: expanded ? "auto" : "250px" }}
                    transition={{ duration: 0.6, ease: "easeInOut" }}
                    className="overflow-hidden relative max-h-fit"
                >
                    <p className="px-6 text-justify font-regular leading-8 text-secondary-main">
                        {benefits}
                    </p>
                </motion.div>


                <div className="absolute -bottom-10 left-0 w-full flex justify-center">
                    <button
                        onClick={() => setExpanded(!expanded)}
                        className="w-full flex justify-center items-center gap-1 text-primary-main font-bold text-body bg-white/80 px-4 pt-6 rounded-t-md"
                    >
                        {expanded ? (
                            <>
                                <span>مشاهده کمتر</span>
                                <IoIosArrowUp />
                            </>
                        ) : (
                            <div className="pt-3 flex items-center gap-1">
                                <span>مشاهده بیشتر</span>
                                <IoIosArrowDown />
                            </div>
                        )}
                    </button>
                </div>
            </div>
        </div>
    );
}
