// import {useState} from "react";
//
// export default function CalculationTableData({items, color}) {
//
//     const [prevType, setPrevType] = useState();
//     const [nextType, setNextType] = useState();
//
//     console.log(items)
//     return (
//         <div className="grid gap-4">
//             {items.map((item, i) => (
//                 <div key={i} className="grid gap-4">
//                     <div
//                         className="grid grid-cols-2"
//                     >
//                         <div className={`${item?.class} ${color ? "text-danger-main": "text-secondary-main"}`}>
//                             {item?.title}
//                         </div>
//
//                         <div className={`flex justify-end text-[16px] ${item.bold ? "font-extrabold" : "font-normal"} ${!item.value ? "text-muted" : "text-secondary-main font-bold"}`}>
//                             {!item.value ?
//                                  "لطفا فیلد ها را پر کنید!"
//                                 : item?.value}
//                         </div>
//
//
//                     </div>
//
//                     { i < items.length - 1 && (
//                         <hr className="h-0.5 bg-box w-full"/>
//                     )}
//
//                 </div>
//             ))}
//         </div>
//
//     )
// };
import React from "react";

export default function CalculationTableData({ items, color }) {
    return (
        <div className="grid gap-4">
            {items.map((item, i) => {
                const nextItem = items[i + 1];
                const isGroupEnd = nextItem && item.group_id !== nextItem.group_id;

                return (
                    <React.Fragment key={i}>
                        <div className="grid grid-cols-2">
                            <div
                                className={`${item?.class} ${
                                    color ? "text-danger-main" : "text-secondary-main"
                                }`}
                            >
                                {item?.title}
                            </div>

                            <div
                                className={`flex justify-end text-[16px] ${
                                    item.bold ? "font-extrabold" : "font-normal"
                                } ${
                                    !item.value
                                        ? "text-muted"
                                        : "text-secondary-main font-bold"
                                }`}
                            >
                                {!item.value ? "لطفا فیلد ها را پر کنید!" : item?.value}
                            </div>
                        </div>

                        {/* خط جداکننده بین آیتم‌ها */}
                        {i < items.length - 1 && (
                            <div
                                className={`w-full ${
                                    isGroupEnd
                                        ? "h-[1px] bg-secondary-main" // اگر گروه تغییر کرد، پررنگ‌تر
                                        : "h-[1px] bg-box" // در حالت عادی
                                }`}
                            ></div>
                        )}
                    </React.Fragment>
                );
            })}
        </div>
    );
}
