"use client"
import React, {useEffect, useState} from "react";
import {
    Chart as ChartJS,
    CategoryScale,
    LinearScale,
    PointElement,
    LineElement,
    Title,
    Legend,
    Filler,
} from "chart.js";
import {Line} from "react-chartjs-2";

ChartJS.register(
    CategoryScale,
    LinearScale,
    PointElement, // اضافه شد
    LineElement,
    Title,
    Legend,
    Filler
);

const arrowPlugin = {
    id: "arrowPlugin",
    afterDraw: (chart) => {
        const {ctx, chartArea: {top, right, bottom, left}} = chart;
        ctx.save();
        ctx.lineWidth = 2;

        // محور X
        ctx.strokeStyle = "#000";
        ctx.fillStyle = "#000";
        ctx.beginPath();
        ctx.moveTo(left, bottom);
        ctx.lineTo(right + 10, bottom);
        ctx.stroke();
        ctx.beginPath();
        ctx.moveTo(right + 10, bottom);
        ctx.lineTo(right, bottom - 5);
        ctx.lineTo(right, bottom + 5);
        ctx.fill();

        // محور Y
        ctx.strokeStyle = "#000";
        ctx.fillStyle = "#000";
        ctx.beginPath();
        ctx.moveTo(left, bottom);
        ctx.lineTo(left, top - 10);
        ctx.stroke();
        ctx.beginPath();
        ctx.moveTo(left, top - 10);
        ctx.lineTo(left - 5, top);
        ctx.lineTo(left + 5, top);
        ctx.fill();


        // فلش انتهای خط داده‌ها
        chart.data.datasets.forEach((dataset) => {
            const meta = chart.getDatasetMeta(0); // فقط اولین dataset
            const points = meta.data;
            if (points.length > 1) {
                const lastPoint = points[points.length - 1];
                const prevPoint = points[points.length - 2];

                const x1 = prevPoint.x;
                const y1 = prevPoint.y;
                const x2 = lastPoint.x;
                const y2 = lastPoint.y;

                const angle = Math.atan2(y2 - y1, x2 - x1);

                ctx.strokeStyle = "#FFBB00";
                ctx.fillStyle = "#FFBB00";
                ctx.beginPath();
                ctx.moveTo(x2, y2);
                ctx.lineTo(
                    x2 - 14 * Math.cos(angle - Math.PI / 8),
                    y2 - 14 * Math.sin(angle - Math.PI / 8)
                );
                ctx.lineTo(
                    x2 - 14 * Math.cos(angle + Math.PI / 8),
                    y2 - 14 * Math.sin(angle + Math.PI / 8)
                );
                ctx.closePath();
                ctx.fill();
            }
        });

        ctx.restore();
    },
};

export default function CustomLineChart({dataChart}) {
    const [time, setTime] = useState([]);
    const [value, setValue] = useState([]);

    useEffect(() => {
        if (dataChart && Array.isArray(dataChart)) {
            setTime(dataChart.map(item => item.date));
            setValue(dataChart.map(item => item.value));
        }
    }, [dataChart]);

    const data = {
        labels: time,
        datasets: [
            {
                data: value,
                borderColor: "#FFBB00",
                tension: 0.4,
                fill: true,
                backgroundColor: "#FFF8E04D",
                pointRadius: 0,
            },
        ],
    };

    const options = {
        responsive: true,
        plugins: {
            legend: {display: false},
        },
        scales: {
            x: {
                grid: {display: false},
                offset: true,
                ticks: {color: "#000", font: {size: 12, weight: 700}},
            },
            y: {
                grid: {display: false},
                min: 0,
                max: 100,
                ticks: {
                    color: "#000",
                    font: {size: 14, weight: 700},
                    callback: function(value) {
                        return value + " %";
                    },
                },
            },
        },
    };

    return (
        <div className="w-[80%]">
            {dataChart?.length > 0 ?
                <Line data={data} options={options} plugins={[arrowPlugin]} />
                :
                <p className="text-center text-h6 font-medium text-Dark-shade9">
                    اطلاعاتی برای نمایش نمودار وجود ندارد!
                </p>
            }
        </div>
    );
}
