"use client"
import { useState } from "react";
import { motion, AnimatePresence } from "framer-motion";
import Table from "@/app/exam/step4/_component/table";
import ExamTable from "@/app/exam/step4/_component/examTable";

const DropdownTable = ({items, index}) => {
    const [isOpen, setIsOpen] = useState(false);

    const toggleDropdown = () => setIsOpen(!isOpen);

    console.log(items)
    return (
        <div className="inline-block border-2 text-nowrap border-primary-main rounded-md ">

            <AnimatePresence initial={false}>
                {isOpen && (
                    <motion.div
                        key="options"
                        initial={{ height: 0, opacity: 0 }}
                        animate={{ height: "auto", opacity: 1 }}
                        exit={{ height: 0, opacity: 0 }}
                        transition={{ duration: 0.4, ease: "easeInOut" }}
                        className="overflow-hidden"
                    >
                        <ExamTable
                            headers={["ردیف", "سوال", "وضعیت پاسخ", "مشاهده پاسخ سوال"]}
                            rows={items.questions.map((item, index) => [
                                index + 1, // ردیف
                                item.question_text || "-", // سرفصل آزمون
                                item.status === "false" ? "پاسخ نادرست" : item.status === "unanswered" ?  "پاسخ داده نشده است" : "پاسخ درست", // ضریب
                                item.right_answer ?? "-", // تعداد سؤال
                            ])}
                        />
                    </motion.div>
                )}
            </AnimatePresence>

            <div onClick={toggleDropdown} className="flex items-center justify-between bg-primary-lighten rounded-lg px-4 py-2 md:py-4 md:scroll-auto md:overflow-x-auto md:overflow-y-auto md:text-sm">

                <div className="flex gap-3 font-bold text-[18px]">

                    <p>{index +1}ـ {items.section_name}</p>
                    <span className="border-l border-muted"></span>

                    <div className="flex gap-2">
                        <p>درصد پاسخگویی:</p>
                        <p className="font-normal">%{items.score_present}</p>
                    </div>


                </div>

                <button className="border-2 flex justify-center px-1 border-black rounded-lg text-[17px] text-black bg-transparent md:mx-6 md:px-5 md:py-1.5">مشاهده</button>
            </div>




        </div>
    );
};

export default DropdownTable;
