



export default function ExamTable({headers, rows}) {


    return (


        <div className="overflow-x-auto">
            <div className="rounded-xl overflow-hidden  md:scroll-auto md:overflow-x-auto md:overflow-y-auto w-full">
                <table className="table-auto w-full text-center">
                    <thead>
                    <tr className="border-b-2 border-black text-lg font-black md:text-[16px]">
                        {headers.map((header, index) => (
                            <th
                                key={index}
                                className={`p-3 relative`}
                            >
                                {index !== headers.length - 1 && (
                                    <span className="absolute left-0 h-[1.5em] border-l border-muted"></span>
                                )}
                                {header}
                            </th>
                        ))}
                    </tr>
                    </thead>
                    <tbody>
                    {rows.map((row, rowIndex) => (
                        <tr key={rowIndex} className="odd:bg-box even:bg-white md:text-sm">
                            {row.map((cell, cellIndex) => (
                                <td
                                    key={cellIndex}
                                    className={`p-3 ${
                                        cellIndex === 0 ? "pr-8 text-right" : ""
                                    }`}
                                >
                                    {cell}
                                </td>
                            ))}
                        </tr>
                    ))}
                    </tbody>
                </table>
            </div>
        </div>
    )
}