"use client";

import Container from "../../ui/container/container";
import logo from "../../../../public/image/logo.svg";
import Image from "next/image";
import {IoIosArrowDown} from "react-icons/io";
import {CiSearch} from "react-icons/ci";
import {TbHeadphonesFilled} from "react-icons/tb";
import {RiShoppingBasket2Line} from "react-icons/ri";
import {IoMenu} from "react-icons/io5";
import React, {useEffect, useState} from "react";
import MegaMenu from "../MegaMenu/MegaMenu";
import {usePathname} from "next/navigation";
import {motion} from "framer-motion";
import LoginModal from "@/components/layout/LoginModal/LoginModal";
import {GET} from "@/services/axios/resources/resourcesAPI";

export default function Header() {
    const pathname = usePathname();
    const [mobileOpen, setMobileOpen] = useState(false);

    const [megaMenuData, setMegaMenuData] = useState([]);

    const [loginModal, setLoginModal] = useState(false);


    const [userName, setUserName] = useState(null);

    useEffect(() => {
        if (typeof window !== "undefined") {
            const storedUser = localStorage.getItem("userName") || "";
            setUserName(storedUser);
        }
    }, []);

    useEffect(() => {
        function fetchMegaMenu() {
            GET("https://www.vakilodoleh.ir/api/v1/menus")
                .then((response) => {
                    if (response?.data) {
                        setMegaMenuData(response.data);

                    }
                })
                .catch((error) => {
                    console.log(error);
                })
        }

        fetchMegaMenu();
    }, []);

    return (
        <>
            {!pathname.startsWith("/exam") && (
                <div className="flex flex-col">
                    <Container className={"bg-box md:bg-white md:px-6 sm:px-2"}>

                        <div className="py-4 flex flex-wrap justify-between md:hidden">
                            <div className="col-span-1 flex items-center gap-3">
                                <Image src={logo} alt="logo" width={100}/>

                                <div className="p-2 h-full w-full rounded-[10px] bg-white flex justify-between">
                                    <div className="flex font-normal items-center gap-4">
                                        <div className="flex items-center text-subT2 text-secondary-main gap-2">
                                            <p>بخشنامه ها</p>
                                            <IoIosArrowDown/>
                                        </div>

                                        <span className="flex h-[70%] w-0.5 bg-border"></span>

                                        <input
                                            className="text-subT1 outline-none placeholder:text-muted text-secondary-main"
                                            placeholder="دنبال چه میگردی ..."
                                        />
                                    </div>

                                    <div className="flex items-center">
                                        <CiSearch className="size-7"/>
                                    </div>
                                </div>
                            </div>

                            <div className="col-span-1 flex items-center gap-10 justify-end">
                                <button
                                    onClick={() => {
                                        if (userName !== "") {

                                        } else {

                                            setLoginModal(!loginModal)
                                        }
                                    }}
                                    className="px-5 h-full bg-black text-white font-bold text-body rounded-[10px]">
                                    {userName === "" ? "ورود / ثبت نام" : (userName)}

                                </button>

                                <div className="flex items-center gap-3">
                                    <div className="flex flex-col justify-between gap-1 font-normal">
                                        <p className="text-body text-secondary-main">09304537723</p>
                                        <p className="text-subT2 text-muted">مشاوره و پشتیبـانی</p>
                                    </div>

                                    <div className="p-3 bg-primary-main rounded-[10px]">
                                        <TbHeadphonesFilled className="size-6 text-white"/>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div className="hidden py-2 md:grid gap-6">
                            <div className="w-full flex justify-between items-center">
                                <Image src={logo} alt="logo" width={100} height={100}/>

                                <div className="flex gap-2">
                                    <div className="p-3 bg-secondary-main rounded-[10px] border border-border">
                                        <RiShoppingBasket2Line className="size-6 text-white"/>
                                    </div>

                                    <button
                                        onClick={() => setMobileOpen(!mobileOpen)}
                                        className="p-3 rounded-[10px] border border-border"
                                    >
                                        <IoMenu className="size-6 text-secondary-main"/>
                                    </button>

                                    <div className="p-3 rounded-[10px] border border-border">
                                        <TbHeadphonesFilled className="size-6 text-secondary-main"/>
                                    </div>
                                </div>
                            </div>

                            <div
                                className="p-2 h-full w-full bg-box rounded-md flex justify-between border border-border">
                                <div className="flex font-normal items-center gap-4">
                                    <div className="flex items-center text-subT2 text-secondary-main gap-2">
                                        <p>بخشنامه ها</p>
                                        <IoIosArrowDown/>
                                    </div>

                                    <span className="flex h-[70%] w-0.5 bg-border"></span>

                                    <input
                                        className="text-subT1 outline-none bg-box placeholder:text-muted text-secondary-main"
                                        placeholder="دنبال چه میگردی ..."
                                    />
                                </div>

                                <div className="flex items-center">
                                    <CiSearch className="size-7"/>
                                </div>
                            </div>
                        </div>
                    </Container>


                    <div>
                        <MegaMenu
                            items={megaMenuData}
                            mobileOpen={mobileOpen}
                            setMobileOpen={setMobileOpen}
                        />
                    </div>

                    <motion.div
                        layout
                        transition={{type: "spring", stiffness: 300, damping: 30}}
                    >
                        {loginModal && (
                            <LoginModal
                                setLoginModal={setLoginModal}
                                setUserName={setUserName}
                            />
                        )}
                    </motion.div>

                </div>
            )}
        </>
    );
}
