/** @type {import('tailwindcss').Config} */
module.exports = {
    content: [
        "./app/**/*.{js,ts,jsx,tsx,mdx}",
        "./pages/**/*.{js,ts,jsx,tsx,mdx}",
        "./components/**/*.{js,ts,jsx,tsx,mdx}",
        // Or if using `src` directory:
        "./src/**/*.{js,ts,jsx,tsx,mdx}",
    ],
    theme: {

        extend: {
            fontSize: {
                t1: "30px",
                t2: "24px",
                t3: "20px",
                body: "15px",
                subT1: "14px",
                subT2: "13px",
            },

            boxShadow: {
                "soft-primary": "0px 0px 64px 0px rgba(255,187,0,0.25)",
            },

            colors: {
                primary: {
                    main: "#FFBB00",
                    lighten: "#FFF8E0",
                },
                secondary: {
                    main: "#0C0D0F",
                    lighten: "#E8E8E6",
                },
                border: '#EFEFEF',
                box: "#F8F8F8",
                text: "#0C0D0F",
                muted: "#949494",
                success: {
                    main: "#14AE5C",
                    lighten: "#E2F5EB",
                },
                info: {
                    main: "#2088F7",
                    lighten: "#D2F0FE",
                },
                warning: {
                    main: "#FFBB00",
                    lighten: "#FFF8E0",
                },
                danger: {
                    main: "#FF3431",
                    lighten: "#FFEFEF",
                }
            }
        },

        screens: {
            "2xl": { max: "1535px" },
            // => @media (max-width: 1535px) { ... }

            xl: { max: "1279px" },
            // => @media (max-width: 1279px) { ... }

            lg: { max: "1023px" },
            // => @media (max-width: 1023px) { ... }

            md: { max: "767px" },
            // => @media (max-width: 767px) { ... }

            sm: { max: "639px" },
            // => @media (max-width: 639px) { ... }
            tablet10: { max: "1280px", min: "800px" },
            // => @media (min-width: 800px) and (max-width: 1280px) { ... }
        },

    },
    plugins: [],
}