"use client";
import {useState, useEffect} from "react";

export default function MultiAnswerQH({
                                          text,
                                          options,
                                          tag,
                                          questionID,
                                          examAttemptID,
                                          resetSignal,
                                          locked,
                                      }) {
    const [selectedIndex, setSelectedIndex] = useState(null);
    const LOCAL_KEY = "exam_answer";

    // 🧠 لود پاسخ ذخیره‌شده یا قبلی
    useEffect(() => {
        const allAnswered = JSON.parse(localStorage.getItem("answered_map")) || {};
        const answeredOptionId = allAnswered[questionID];

        if (answeredOptionId) {
            const idx = options.findIndex((opt) => opt.id === answeredOptionId);
            if (idx !== -1) setSelectedIndex(idx);
            return;
        }

        const saved = JSON.parse(localStorage.getItem(LOCAL_KEY));
        if (saved && saved.question_id === questionID) {
            const idx = options.findIndex(
                (opt) => opt.id === saved.question_option_id
            );
            if (idx !== -1) setSelectedIndex(idx);
        } else {
            setSelectedIndex(null);
        }
    }, [questionID, options, resetSignal]);

    // 🖱️ انتخاب گزینه
    const handleSelect = (index) => {
        if (locked) return;

        const isUpdatePermitted = Number(
            localStorage.getItem("is_update_answer_permitted")
        );
        const answeredBefore =
            JSON.parse(localStorage.getItem("answered_questions")) || [];

        if (isUpdatePermitted === 0 && answeredBefore.includes(questionID)) return;

        const selectedOption = options[index];
        const answer = {
            question_id: questionID,
            question_option_id: selectedOption.id,
            exam_attempt_id: examAttemptID,
        };

        localStorage.setItem(LOCAL_KEY, JSON.stringify(answer));
        setSelectedIndex(index);
    };

    return (
        <div className="grid gap-8">
            <div className="grid gap-2">
                <p className="text-secondary-main font-black text-t2 md:text-lg">
                    {text}
                </p>
                <p className="text-secondary-main text-xl md:text-sm">
                    (این سوال برای سنجش توانایی شما در {tag} می‌باشد)
                </p>
            </div>

            {/* گزینه‌ها به صورت افقی */}
            <div className="grid grid-cols-4 gap-4 text-secondary-main">
                {options.map((item, index) => (
                    <button
                        key={index}
                        onClick={() => handleSelect(index)}
                        disabled={locked}
                        className={`flex  items-center gap-2 py-3 px-6 border rounded-xl transition-all duration-200 font-semibold
                                 ${
                            selectedIndex === index
                                ? "bg-success-lighten border-success-main text-success-dark"
                                : "bg-white border-secondary-main"
                        }
                                   ${locked ? "opacity-60 cursor-not-allowed" : ""}
                                   `}
                    >
                        <div
                            className={`flex items-center justify-center border-[1.5px] rounded-lg w-9 h-9 md:w-7 md:h-7 text-lg font-bold
                                  ${
                                selectedIndex === index
                                    ? "bg-success-main border-success-main text-white"
                                    : "bg-secondary-lighten border-secondary-main text-secondary-main"
                            }`}
                        >
                             {index + 1}
                        </div>
                        {item.text}
                    </button>
                ))}
            </div>
        </div>
    );
}
