"use client";

import Image from "next/image";
import logo from "@/../public/icons/logo.svg";
import { useState, useEffect } from "react";
import { useRouter } from "next/navigation";
import { POST } from "@/services/axios/resources/resourcesAPI";
import toast from "react-hot-toast";

export default function Page() {
    const [examAttemptId, setExamAttemptId] = useState(null);
    const [userComment, setUserComment] = useState("-");
    const [examName, setExamName] = useState("");
    const [loading, setLoading] = useState(false);
    const router = useRouter();

    useEffect(() => {
        // Only runs on client
        const exam_info = localStorage.getItem("exam_info");
        const name = localStorage.getItem("examName");

        if (exam_info) {
            const parsed = JSON.parse(exam_info);
            setExamAttemptId(Number(parsed?.exam_attempt_id));
        }

        if (name) {
            try {
                setExamName(JSON.parse(name));
            } catch {
                setExamName(name);
            }
        }
    }, []);

    function handleSubmit() {
        if (!examAttemptId) return;

        if (!userComment) {
            router.push("/exam/step4");
            return;
        }

        setLoading(true);
        const payload = { user_comment: userComment };

        POST(`/api/exam/exam-attempts/${examAttemptId}/comment`, payload)
            .then(() => router.push("/exam/step4"))
            .catch(() => toast.error("ارسال نظر با خطا مواجه شد"))
            .finally(() => setLoading(false));
    }

    return (
        <div className="w-full min-h-[100vh] bg-primary-lighten flex flex-col gap-10 items-center justify-center md:py-12">
            <div className="flex gap-2 items-center justify-evenly">
                <Image src={logo} alt={"logo"} width={34} />
                <p className="font-black text-t2 md:text-body border-b-2 border-secondary-main text-secondary-main">
                    {examName || ""}
                </p>
            </div>

            <div className="flex flex-col gap-3 items-center md:px-6 text-center">
                <p className="text-t2 font-black md:text-lg">محمدمهدی ایمنی عزیز</p>
                <p className="text-t2 font-black md:text-lg">
                    {examName} به پایان رسید!
                </p>
                <p className="text-t2 font-black md:text-lg">
                    در ادامه میتونی به صورت آنی نتیجه آزمونت رو ببینی و خودت رو کامل آنالیز کنی!
                </p>
            </div>

            <div className="flex flex-col gap-2 w-[90%]">
                <p className="text-t1 font-black md:text-lg">نظرسنجی آزمون (اختیاری)</p>

                <textarea
                    className="bg-white px-4 min-h-[35vh] py-6 border border-black rounded-xl text-t3 placeholder:font-normal md:text-[16px]"
                    placeholder="برای افزایش کیفیت خدمات راوی حساب به شما لطفا پیشنهاد و نظر خود را در مورد آزمون بیان کنید ..."
                    onChange={(e) => setUserComment(e.target.value)}
                />
            </div>

            <button
                onClick={handleSubmit}
                disabled={loading || !examAttemptId}
                className="px-12 py-2 text-t3 font-black text-white bg-success-main rounded-lg md:text-lg md:py-3"
            >
                {loading ? "در حال ارسال..." : "مشاهده نتیجه آزمون"}
            </button>
        </div>
    );
}
