"use client"
import {CiLinkedin} from "react-icons/ci";
import {SiAparat} from "react-icons/si";
import {PiInstagramLogoLight, PiTelegramLogoLight} from "react-icons/pi";
import {FaAngleUp} from "react-icons/fa";
import {useState} from "react";
import {motion, AnimatePresence} from "framer-motion";
import {usePathname} from "next/navigation";
import raviLogo from "../../../../public/icons/footerLogo.svg"
import Image from "next/image";



export default function Footer() {

    const pathname = usePathname();

    const [accessDropDown, setAccessDropDown] = useState(false);
    const [rulesDropDown, setRulesDropDown] = useState(false);
    const [resalateDropDown, setResalateDropDown] = useState(false);


    const quickAccess = [
        "آموزش مالیات بر ارث",
        "وکیل مالیاتی",
        "آموزش مالیات حقوق",
        "دادرسی مالیاتی",
        "آموزش مالیات دستگاه پوز",
        "خدمات مالیاتی",
        "آموزش مالیات تراکنش بانکی",
        "بخشنامه مالیاتی",
        "آموزش معاف از مالیات",
        "آموزش معاف از مالیات",
    ]

    const rules = [
        "مقررات امنیتی",
        "قوانین کشور",
        "مقررات وزارت کار",
        "مقررات وزارت صنعت،معدن و تجارت",
        "مقررات گمرک",
        "اطلاعیه های مالیاتی",
        "مقررات قوه قضائیه",
        "بخشنامه های وزارت اقتصاد",
        "مقررات بیمه‌ای",
        "مقررات بانک مرکزی"
    ]

    return (

        <>
            {!pathname.startsWith("/exam") && (

                <div className="flex flex-col">

                    <div className="bg-secondary-main px-12 py-10 flex flex-col gap-10 md:px-5 md:gap-5">

                        <div className="grid grid-cols-3 text-white gap-6 md:grid-cols-1">

                            <div className="flex flex-col gap-4">
                                <div className="text-t3 font-medium md:hidden">دسترسی سریع</div>
                                <button
                                    onClick={() => setAccessDropDown(!accessDropDown)}
                                    className="text-lg font-medium w-full bg-white/10 rounded-md h-14 items-center px-3 md:flex justify-between text-t3 md:block hidden z-10"
                                >
                                    دسترسی سریع
                                    <FaAngleUp className={`transition transform duration-500 ${accessDropDown ? "-rotate-180" : "rotate-0"}`} />
                                </button>

                                <div className="md:hidden grid grid-cols-2 gap-3 text-subT1">
                                    {quickAccess.map((item, index) => (
                                        <div key={index}>{item}</div>
                                    ))}
                                </div>

                                <AnimatePresence>
                                    {accessDropDown && (
                                        <motion.div
                                            initial={{ height: 0, opacity: 0 }}
                                            animate={{ height: "auto", opacity: 1 }}
                                            exit={{ height: 0, opacity: 0 }}
                                            transition={{ duration: 0.4, ease: "easeInOut" }}
                                            className="grid grid-cols-2 gap-3 md:text-subT1 overflow-hidden md:px-3"
                                        >
                                            {quickAccess.map((item, index) => (
                                                <div key={index}>{item}</div>
                                            ))}
                                        </motion.div>
                                    )}
                                </AnimatePresence>
                            </div>

                            <div className="flex flex-col gap-4">
                                <div className="text-t3 font-medium md:hidden">مقررات و بخشنامه‌ها</div>
                                <button
                                    onClick={() => setRulesDropDown(!rulesDropDown)}
                                    className="text-lg font-medium w-full bg-white/10 rounded-md h-14 items-center px-3 md:flex justify-between text-t3 md:block hidden z-10"
                                >
                                    مقررات و بخشنامه‌ها
                                    <FaAngleUp className={`transition transform duration-500 ${rulesDropDown ? "-rotate-180" : "rotate-0"}`} />
                                </button>

                                <div className="md:hidden grid grid-cols-2 gap-3 text-subT1">
                                    {rules.map((item, index) => (
                                        <div key={index}>{item}</div>
                                    ))}
                                </div>

                                <AnimatePresence>
                                    {rulesDropDown && (
                                        <motion.div
                                            initial={{ height: 0, opacity: 0 }}
                                            animate={{ height: "auto", opacity: 1 }}
                                            exit={{ height: 0, opacity: 0 }}
                                            transition={{ duration: 0.4, ease: "easeInOut" }}
                                            className="grid grid-cols-2 gap-3 md:text-subT1 overflow-hidden md:px-3"
                                        >
                                            {rules.map((item, index) => (
                                                <div key={index}>
                                                    {item}
                                                </div>
                                            ))}
                                        </motion.div>
                                    )}
                                </AnimatePresence>
                            </div>

                            <div className="flex flex-col gap-4">
                                <div className="text-t3 font-medium md:hidden">رسالت راوی حساب</div>
                                <button
                                    onClick={() => setResalateDropDown(!resalateDropDown)}
                                    className="text-lg font-medium w-full bg-white/10 rounded-md h-14 items-center px-3 md:flex justify-between text-t3 md:block hidden z-10"
                                >
                                    رسالت راوی حساب
                                    <FaAngleUp className={`transition transform duration-500 ${resalateDropDown ? "-rotate-180" : "rotate-0"}`} />
                                </button>

                                <div className="md:hidden text-justify leading-8 gap-3 text-subT1">
                                    رسالت موسسه خدماتی آموزشی راوی حساب بهبود و ارتقا دانش مالیاتی افراد است. تیم راوی حساب با نیازها و مشکلات مالیاتی افراد آشناست و با ارائه آموزش‌ مالیات در فرمت های متنوع و جامع، تلاش کرده تا اطلاعات و مهارت‌های لازم برای مدیریت بهتر امور مالی و دستیابی به بهره‌وری بیشتر را به مخاطبین عزیز انتقال دهیم تا مخاطبین و مشتریان گرانقدر ما ...
                                </div>

                                <AnimatePresence>
                                    {resalateDropDown && (
                                        <motion.div
                                            initial={{ height: 0, opacity: 0 }}
                                            animate={{ height: "auto", opacity: 1 }}
                                            exit={{ height: 0, opacity: 0 }}
                                            transition={{ duration: 0.4, ease: "easeInOut" }}
                                            className="md:text-subT1 overflow-hidden leading-8 text-justify"
                                        >
                                            <div>
                                                رسالت موسسه خدماتی آموزشی راوی حساب بهبود و ارتقا دانش مالیاتی افراد است. تیم راوی حساب با نیازها و مشکلات مالیاتی افراد آشناست و با ارائه آموزش‌ مالیات در فرمت های متنوع و جامع، تلاش کرده تا اطلاعات و مهارت‌های لازم برای مدیریت بهتر امور مالی و دستیابی به بهره‌وری بیشتر را به مخاطبین عزیز انتقال دهیم تا مخاطبین و مشتریان گرانقدر ما ...
                                            </div>
                                        </motion.div>
                                    )}
                                </AnimatePresence>
                            </div>

                        </div>

                        <div className="bg-white flex-wrap rounded-md p-5 gap-3 flex items-center justify-between md:p-3">

                            <div className="flex gap-3 items-center md:gap-0">
                                <div
                                    className="border border-secondary-main flex items-center justify-center w-[52px] h-[52px] rounded-md md:border-none">
                                    <img src="https://www.ravihesab.com/assets/site/icons/location.svg" alt=""/>
                                </div>

                                <div className="flex flex-col gap-2">
                                    <p className="text-muted text-md md:hidden">
                                        آدرس:
                                    </p>
                                    <p className="text-secondary text-md">
                                        تهران – خیابان شریعتی روبروی ظفر کوچه صادقیان پلاک ۱ - جهت حضور فقط با هماهنگی قبلی
                                    </p>
                                </div>
                            </div>

                            <div className="flex gap-3 items-center md:gap-0">
                                <div
                                    className="border border-secondary-main flex items-center justify-center w-[52px] h-[52px] rounded-md md:border-none">
                                    <img src="https://www.ravihesab.com/assets/site/icons/sms.svg" alt="" className=""/>
                                </div>
                                <div className="flex flex-col gap-2">
                                    <p className="text-muted text-md md:hidden">
                                        ایمیل:
                                    </p>
                                    <p className="text-secondary-main text-md">
                                        info@ravihesab.com
                                    </p>
                                </div>
                            </div>

                            <div className="flex gap-3 items-center md:gap-0">
                                <div
                                    className="border border-secondary-main flex items-center justify-center w-[52px] h-[52px] rounded-md md:border-none">
                                    <img src="https://www.ravihesab.com/assets/site/icons/call-calling.svg" alt=""/>
                                </div>
                                <div className="flex flex-col gap-2">
                                    <p className="text-muted text-md md:hidden">
                                        تماس:
                                    </p>
                                    <p className="text-secondary-main text-md">
                                        09208521185
                                    </p>
                                </div>
                            </div>

                            <div className="flex gap-3 items-center md:gap-0">
                                <div
                                    className="border border-secondary-main flex items-center justify-center w-[52px] h-[52px] rounded-md md:border-none">
                                    <img src="https://www.ravihesab.com/assets/site/icons/clock.svg" alt=""/>
                                </div>
                                <div className="flex flex-col gap-2">
                                    <p className="text-muted text-md md:hidden">
                                        ساعات کاری:
                                    </p>
                                    <p className="text-secondary-main text-md">
                                        8 صبح الی 17:30
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div className="bg-[#18191a] w-full px-12 py-5 flex flex-wrap items-center justify-between md:flex-col md:gap-6">

                        <div className="flex gap-3 items-center justify-center">
                            <div className="w-[50px] h-[50px] rounded-md flex items-center justify-center bg-white">
                                <Image src={raviLogo} alt="" width={45} height={45} />
                            </div>

                            <div className="w-[50px] h-[50px] rounded-md flex items-center justify-center bg-white">
                                <img src="https://ravihesab.com/assets/site/images/samandehi.png" loading="lazy"
                                     alt="وب سایت آموزش قوانین مالیاتی"
                                />
                            </div>
                            <div className="w-[50px] h-[50px] rounded-md flex items-center justify-center bg-white">
                                <img
                                    className="object-cover" referrerPolicy="origin"
                                    src="https://ravihesab.com/assets/site/images/enamad.png" alt=""/>
                            </div>
                        </div>

                        <p className="text-md text-white text-center">
                            تمامی حقوق مادی و معنوی این وبسایت متعلق به راوی
                            حساب می‌باشد.
                        </p>

                        <div className="flex gap-2">

                            <a
                                href="https://www.aparat.com/ravihesab"
                                className="bg-white w-12 h-12 rounded-full flex items-center justify-center"
                            >
                                <SiAparat className="text-[#4d4d4d]" size={21} />
                            </a>

                            <a
                                href="https://www.instagram.com/ravihesab"
                                className="bg-white w-12 h-12 rounded-full flex items-center justify-center"
                            >
                                <PiInstagramLogoLight size={21} />
                            </a>

                            <a
                                href="https://t.me/ravihesab"
                                className="bg-white w-12 h-12 rounded-full flex items-center justify-center"
                            >
                                <PiTelegramLogoLight size={21} />
                            </a>

                            <a
                                className="bg-white w-12 h-12 rounded-full flex items-center justify-center"
                                href="https://www.linkedin.com/in/mohammadjavad-azimifard/"
                            >
                                <CiLinkedin className="text-[#4d4d4d]" size={23} />
                            </a>
                        </div>
                    </div>
                </div>
            )}



        </>
    )

}