'use client'

import infoIcon from "../../../../public/icons/info.png";
import Image from "next/image";
import {useState} from "react";
import {AnimatePresence} from "framer-motion";
import Input from "@/components/ui/input/Input";

export default function InputContainer({item, requiredFields = [], selectedInputs = [], setRequiredFieldValues, requiredFieldValues, requiredFieldErrors}) {

    const [salaryBasis, setSalaryBasis] = useState(false);

    const combined = [...requiredFields, ...selectedInputs];


    return (
        <div className="p-4 rounded-2xl border-[1.5px] border-muted flex flex-col">
            <div className="flex w-full justify-between md:flex-col md:gap-6">
                <div className="flex items-center gap-2 text-secondary-main font-bold text-[16px] text-lg">
                    <div className="w-1.5 h-1.5 bg-primary-main"></div>
                    {item?.value}
                </div>

                <div className="flex items-center gap-5 flex-wrap">
                    <div
                        className={`flex min-w-fit items-center gap-2 transform transition-all duration-300 
                                 md:text-[16px] ${!salaryBasis ? "font-bold text-secondary-main" : "font-medium text-muted"}`}
                    >
                        مبنای وزارت کار
                        <Image src={infoIcon} alt="" className="w-4 h-4" width={4} height={4}/>
                    </div>

                    <div className="flex justify-center min-w-fit">
                        <button
                            onClick={() => setSalaryBasis(!salaryBasis)}
                            className="w-10 h-6 rounded-full bg-secondary-main flex items-center justify-start p-1 md:w-[50px] md:h-[28px]"
                        >
                            <div
                                className={`w-4 h-4 bg-primary-main rounded-full transform transition-all duration-300 md:w-5 md:h-5 
                                         ${salaryBasis ? "-translate-x-4 md:-translate-x-[22px]" : "translate-x-0"}`}
                            ></div>
                        </button>
                    </div>

                    <div
                        className={`flex min-w-fit items-center justify-end gap-2 transform transition-all duration-300 
                                    ${salaryBasis ? "font-bold text-secondary-main" : "font-medium text-muted"}`}
                    >
                        مبنای قرارداد
                        <Image src={infoIcon} alt="" className="w-4 h-4" width={4} height={4}/>
                    </div>
                </div>

            </div>

            <hr className="h-0.5 bg-muted w-full mt-4 mb-6"/>

            <div className="grid grid-cols-2 lg:grid-cols-2 gap-4 md:grid-cols-1 md:gap-8">
                <AnimatePresence>
                    {combined?.map((field, index) => (
                        <Input
                            key={field.id || index}
                            setRequiredFieldValues={setRequiredFieldValues}
                            requiredFieldErrors={requiredFieldErrors}
                            requiredFieldValues={requiredFieldValues}
                            item={{
                                ...field,
                                name: field.name,
                                placeHolder: field.placeHolder,
                                type: field.type,
                                active: true
                            }}
                            index={index}
                        />
                    ))}
                </AnimatePresence>
            </div>
        </div>

    )
};